//package globalExamples;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmStandardMember;

import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Model;

import java.util.List;
import java.util.Iterator;

/**
 * Complete code for Example 6-12, Creating an Assignment That Depends on
 * Another Assignment, in Chapter 6, Understanding Source Objects, in the Oracle
 * Oracle OLAP Developer's Guide to the OLAP API.
 * This program creates two custom members of the Product dimension.
 * The value that Oracle OLAP assigns for one of the custom members is
 * dependent on the value assigned by the other custom member.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class CreateDependentAssignment
{

  public void run(String[] args)
  {
    // Create a PrintWriter and objects for connecting to the database and
    // getting the metadata.
    Context10g context = new Context10g(args, false);

    context.println("Example 6-12, Creating an Assignment That Depends on " +
                    "Another Assignment,\n");

    // Get the DataProvider.
    DataProvider dp = context.getDataProvider();

    // Get the dimensions. Cast the MdmPrimaryDimension for the Product dimension
    // as an MdmStandardDimension so it has a createCustomMember method.
    MdmStandardDimension mdmProdStdDim = (MdmStandardDimension)
                                          context.getMdmPrimaryDimensionByName("PRODUCT");
    MdmPrimaryDimension mdmTimeDim = context.getMdmPrimaryDimensionByName("TIME");

    // Get the Source for the Product dimension.
    Source prodStdDim = mdmProdStdDim.getSource();

    // Get the default hierarchies of the dimensions and the Source objects for them.
    MdmLevelHierarchy mdmCalendar = (MdmLevelHierarchy) mdmTimeDim.getDefaultHierarchy();
    MdmLevelHierarchy mdmProdRollup = (MdmLevelHierarchy) mdmProdStdDim.getDefaultHierarchy();
    StringSource calendar = (StringSource) mdmCalendar.getSource();
    StringSource prodRollup = (StringSource) mdmProdRollup.getSource();

    // Get the Unit Cost and Unit Price measures and the Source objects for them.
    MdmMeasure mdmUnitCost = context.getMdmMeasureByName("UNIT_COST");
    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");

    NumberSource unitCost = (NumberSource) mdmUnitCost.getSource();
    NumberSource unitPrice = (NumberSource) mdmUnitPrice.getSource();

    // Get the level to which the dimension members belong.
    MdmLevel mdmItemLevel = context.getLevelByName(mdmProdRollup, "ITEM");

    // Get the placeholder Source for the Number data type.
    Source ph = dp.getFundamentalMetadataProvider()
                  .getNumberPlaceholder()
                  .getSource();

    // Get a Source that specifies the value to assign for the custom member.
    Source calc = ((NumberSource)
                  (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::14")))
                  .plus(
                  (NumberSource)
                  (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::15")));


    // Create a custom member of the Item level of the Product dimension.
    MdmStandardMember mdmItem60 = mdmProdStdDim.createCustomMember(
                                                  "60",  // member local value
                                                  mdmItemLevel, // member level
                                                  "4",   // parent local value
                                                  calc, // calculation Source
                                                  10);   // precedence value

    // Get a Source that specifies a value to assign for another custom member
    // that depends on the value to assign for the first custom member.
    Source dependentCalc = ((NumberSource)
                      (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::60")))
                      .plus(
                      (NumberSource)
                      (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::13")));

    // Create another custom member of the Item level of the Product dimension.
    MdmStandardMember mdmItem61 = mdmProdStdDim.createCustomMember(
                                                      "61",
                                                      mdmItemLevel,
                                                      "4",
                                                      dependentCalc,
                                                      10);

    // Produce a selection of hierarchy members that includes the custom members.
    StringSource prodSel = prodRollup.selectValues(
                                       new String[]{"PRODUCT_ROLLUP::ITEM::13",
                                                    "PRODUCT_ROLLUP::ITEM::14",
                                                    "PRODUCT_ROLLUP::ITEM::15",
                                                    "PRODUCT_ROLLUP::ITEM::60",
                                                    "PRODUCT_ROLLUP::ITEM::61"
                                                    });

    // Produce a Source that specifies the Unit Cost and Unit Price values
    // for the selected Product and Time dimension members.
    Source result = unitPrice.join(unitCost)
                             .join(prodSel)
                             .join(calendar, "CALENDAR::MONTH::47");

    // Prepare and commit the current Transaction.
    context.commit();

    // Displays the values of a Cursor for result.
    context.displayResult(result);

  }

  public static void main(String[] args)
  {
    new CreateDependentAssignment().run(args);
  }
}

